<?php
	ob_start();

	$issues = array();

	// Check #1: Admin Files In-tact?

	$checks = array(
		'admin/index.php',
		'admin/docs/',
		'admin/bin/main.php',
		'admin/bin/diagnostics.php',
		'admin/i.header.php',
		'admin/i.footer.php'
	);

	foreach($checks as $file) {
		if(!file_exists("../../" . $file)) {
			$issues[] = array(
				'Problem' => "Missing File",
				'Detail' => $file,
				'Fixed' => false
			);
		}
	}

	// Check #2: Main Libraries In-tact?

	$checks = array(
		'php/pagerank.php',
		'php/simple_html_dom.php',
        'structures/nav.php'
	);

	foreach($checks as $file) {
		if(!file_exists("../../" . $file)) {
			$issues[] = array(
				'Problem' => "Missing Library",
				'Detail' => $file,
				'Fixed' => false
			);
		}
	}

	// Check #3: Can read language and database files?

	$db = "../../data/main.db";
	if(!file_exists($db)) {
		file_put_contents($db, "[]");
		
		$issues[] = array(
			'Problem' => "Missing Database",
			'Detail' => 'data/main.db',
			'Fixed' => true
		);
	}

	$dbs = array(
		'main.db'
	);

	foreach($dbs as $db) {
		$f = file_get_contents("../../data/{$db}");
		$c = json_decode($f, true);

		if($c === null) {
			$issues[] = array(
				'Problem' => "Corrupt Database",
				'Detail' => 'data/{$db}.json',
				'Fixed' => false
			);
		}
	}

	// Check #4: Check for error logs

	if(file_exists("../error.log") || file_exists("../error_log")) {
		$issues[] = array(
			'Problem' => "System Errors",
			'Detail' => 'Please review the box below.',
			'Fixed' => false
		);
	}
	if(file_exists("../../error.log") || file_exists("../../error_log")) {
		$issues[] = array(
			'Problem' => "System Errors",
			'Detail' => 'Please review the box below.',
			'Fixed' => false
		);
	}

	// Check #5: Can the homepage be seen?

	if(file_exists("../../index.html")) {
		$issues[] = array(
			'Problem' => "Homepage Override",
			'Detail' => 'An index.html file is present, and might be blocking index.php.',
			'Fixed' => false
		);
	}

	// Check #6: Check for initialization files


	$checks = array(
		'structures/nav.php',
		'structures/footer.php',
		'structures/header.php'
	);

	foreach($checks as $file) {
		if(!file_exists("../../" . $file)) {
			$issues[] = array(
				'Problem' => "Missing Initializer",
				'Detail' => $file,
				'Fixed' => false
			);
		}
	}

	// Check #7: Can a valid result be retrieved from Google (over HTTPS/SSL)??

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "https://www.google.com/search?q=webfector");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
	$data = curl_exec($ch);

	if(curl_errno($ch) !== 0 || strpos($data, "unusual traffic") !== false) {
		$issues[] = array(
			'Problem' => "Connection Issue",
			'Detail' => 'Failed to receive results from Google over a secure (https) connection.',
			'Fixed' => false
		);
	}
	curl_close($ch);

	// Check #8: Can a valid result be retrieved from Google (over HTTP/non-SSL)?

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "http://www.google.com/search?q=webfector");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
	$data = curl_exec($ch);

	if(curl_errno($ch) !== 0 || strpos($data, "unusual traffic") !== false) {
		$issues[] = array(
			'Problem' => "Connection Issue",
			'Detail' => 'Failed to receive results from Google over a normal (http) connection.',
			'Fixed' => false
		);
	}
	if(strpos($data, "unusual traffic") !== false) {
		$issues[] = array(
			'Problem' => "Blocked By Google",
			'Detail' => 'Your server IP is blocked by Google. This is not caused by SEO Studio.',
			'Fixed' => false
		);
	}
	curl_close($ch);

	// Check #9: Can I connect to the Altusia API?

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "http://api.altusia.com/echo");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
	$data = curl_exec($ch);
	curl_close($ch);

	if(trim($data) !== "echo") {
		$issues[] = array(
			'Problem' => "Connection Issue",
			'Detail' => 'Failed to connect to the Altusia API.',
			'Fixed' => false
		);
	}
?>

<table class="table table-striped" width="100%">
	<thead>
		<tr>
			<th>Problem</th>
			<th>Details</th>
			<th>Fixed</th>
		</tr>
	</thead>
	<tbody>
<?php
	foreach($issues as $issue) {
?>
		<tr>
			<td><?=$issue['Problem'];?></td>
			<td><?=$issue['Detail'];?></td>
			<td><?php
				if($issue['Fixed']) echo "Yes";
				else echo "No";
			?></td>
		</tr>
<?php
	}

	if(count($issues) == 0) {
		echo "<tr><td colspan='3'>No issues found!</td></tr>";
	}
?>
	</tbody>
</table>